<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class VisualizzatoreGalleria {
        private $db;
        private $id;
        private $nome;
        private $idGalleria;
        private $spazioOccupato;
        private $aspetto;
        private $aspectRatio;
        
        public function __construct($db, $id, $nome="", $idGalleria=0, $spazioOccupato="",  $aspetto="", $aspectRatio="") {
            $this->db = $db;
            $this->id = $id;
            $this->nome = $nome;
            $this->idGalleria = $idGalleria;
            $this->spazioOccupato = $spazioOccupato;
            $this->aspetto = $aspetto;
            $this->aspectRatio = $aspectRatio;
        }

        function crea() {
            $query    = "INSERT INTO geec_visualizzatoriGallerie VALUES(NULL,'$this->nome','$this->idGalleria','$this->spazioOccupato','$this->aspetto','$this->aspectRatio')";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        function modifica() {
            $query    = "UPDATE geec_visualizzatoriGallerie SET nome='$this->nome', idGalleria=$this->idGalleria, spazioOccupato='$this->spazioOccupato', tipoVisualizzazione='$this->aspetto', aspectRatio='$this->aspectRatio' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geec_visualizzatoriGallerie",$this->id);
            
            // elimina le occorrenze in cui la form è presente, l'id di questo componente è 31
            eliminaOccorrenzeComponente($this->db,$this->id,31);
        }
        
        function duplica() {
            $query    = "INSERT INTO geec_visualizzatoreProfili VALUES(NULL,'Copia di $this->nome')";
            $idNuovaForm = $this->db->eseguiQueryCreazione($query);
            
            return $idNuovaForm;
        }
        
        function caricaDatiDalDatabase() {
            $datiGriglia   = $this->db->leggiSingolaRiga("geec_visualizzatoriGallerie",$this->id);
            $this->nome              = $datiGriglia["nome"];
            $this->spazioOccupato    = $datiGriglia["spazioOccupato"];
            $this->aspetto           = $datiGriglia["tipoVisualizzazione"];
            $this->aspectRatio       = $datiGriglia["aspectRatio"];
            $this->idGalleria        = $datiGriglia["idGalleria"];
        }
        
        // getter & setter
        
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getNome() {
            return $this->nome;
        }

        public function getIdGalleria() {
            return $this->idGalleria;
        }

        public function getSpazioOccupato() {
            return $this->spazioOccupato;
        }

        public function getAspetto() {
            return $this->aspetto;
        }

        public function getAspectRatio() {
            return $this->aspectRatio;
        }

        public function setDb($db): void {
            $this->db = $db;
        }

        public function setId($id): void {
            $this->id = $id;
        }

        public function setNome($nome): void {
            $this->nome = $nome;
        }

        public function setIdGalleria($idGalleria): void {
            $this->idGalleria = $idGalleria;
        }

        public function setSpazioOccupato($spazioOccupato): void {
            $this->spazioOccupato = $spazioOccupato;
        }

        public function setAspetto($aspetto): void {
            $this->aspetto = $aspetto;
        }

        public function setAspectRatio($aspectRatio): void {
            $this->aspectRatio = $aspectRatio;
        }

    }